<?php
// scan.php
require_once __DIR__ . '/config/config.php';

date_default_timezone_set("Asia/Jakarta"); 
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rfid_uid = trim($_POST['rfid_uid']);
    $jam_sekarang = date("H:i:s");
    $tanggal = date("Y-m-d");

    // aturan jam kerja
    $jam_masuk  = "08:00:00";
    $jam_pulang = "17:00:00";

    // cek karyawan
    $stmt = $pdo->prepare("SELECT * FROM employees WHERE rfid_uid = ?");
    $stmt->execute([$rfid_uid]);
    $employee = $stmt->fetch();

    if ($employee) {
        $emp_id = $employee['id'];

        // ambil absensi hari ini
        $stmt = $pdo->prepare("SELECT * FROM attendances 
                               WHERE employee_id = ? AND attendance_date = ?
                               ORDER BY created_at ASC");
        $stmt->execute([$emp_id, $tanggal]);
        $records = $stmt->fetchAll();
        $total_absen = count($records);

        if ($total_absen == 0) {
            // Tap pertama → Masuk
            $type   = 'masuk';
            $status = ($jam_sekarang > $jam_masuk) ? 'terlambat' : 'hadir';

            $stmt = $pdo->prepare("INSERT INTO attendances 
                (employee_id, rfid_uid, type, status, attendance_date, created_at) 
                VALUES (?, ?, ?, ?, CURDATE(), NOW())");
            $stmt->execute([$emp_id, $rfid_uid, $type, $status]);

            $message = "✅ " . htmlspecialchars($employee['name']) . " absen $type [$status]";

        } elseif ($total_absen == 1) {
            // Sudah absen masuk → cek apakah boleh absen pulang
            if ($jam_sekarang >= $jam_pulang) {
                $type   = 'pulang';
                $status = 'hadir';

                $stmt = $pdo->prepare("INSERT INTO attendances 
                    (employee_id, rfid_uid, type, status, attendance_date, created_at) 
                    VALUES (?, ?, ?, ?, CURDATE(), NOW())");
                $stmt->execute([$emp_id, $rfid_uid, $type, $status]);

                $message = "👋 " . htmlspecialchars($employee['name']) . " absen $type.";
            } else {
                $message = "⚠️ Belum saatnya absen pulang. Jam pulang: $jam_pulang";
            }

        } else {
            // Sudah dua kali tap
            $message = "❌ " . htmlspecialchars($employee['name']) . " sudah lengkap absen hari ini.";
        }

    } else {
        $message = "❌ UID RFID tidak dikenali.";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Scan RFID</title>
  <style>
    body { font-family: Arial, sans-serif; background: #f0f0f0; text-align: center; padding: 40px; }
    .card { background: white; padding: 30px; border-radius: 8px; display: inline-block; box-shadow: 0 2px 6px rgba(0,0,0,0.1); }
    input { padding: 10px; width: 250px; font-size: 18px; margin-top: 10px; }
    button { padding: 10px 20px; font-size: 18px; margin-top: 10px; cursor: pointer; }
    .msg { margin-top: 20px; font-weight: bold; }
  </style>
</head>
<body>
  <div class="card">
    <h2>Scan RFID Karyawan</h2>
    <form method="POST">
      <input type="text" name="rfid_uid" placeholder="Tempelkan kartu RFID" autofocus required>
      <br>
      <button type="submit">Absen</button>
    </form>
    <?php if (!empty($message)): ?>
      <div class="msg"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>
  </div>
</body>
</html>
