<?php
require_once __DIR__ . '/../config/config.php';
//$pdo = getDB();

$id = intval($_GET['id'] ?? 0);

// Ambil data karyawan
$stmt = $pdo->prepare("SELECT * FROM employees WHERE id = ?");
$stmt->execute([$id]);
$employee = $stmt->fetch();

if (!$employee) {
    die("Karyawan tidak ditemukan.");
}

// Update kehadiran
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $att_id = intval($_POST['attendance_id']);
    $status = $_POST['status'];
    $stmt = $pdo->prepare("UPDATE attendances SET status = ? WHERE id = ?");
    $stmt->execute([$status, $att_id]);
    header("Location: employee_edit.php?id=".$id);
    exit;
}

// Ambil semua absensi karyawan ini
$stmt = $pdo->prepare("SELECT * FROM attendances WHERE employee_id = ? ORDER BY created_at DESC");
$stmt->execute([$id]);
$attendances = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Edit Kehadiran - <?= htmlspecialchars($employee['name']) ?></title>
  <style>
    body { font-family: Arial, sans-serif; background:#f4f4f4; padding:20px; }
    table { width:100%; border-collapse: collapse; background:#fff; margin-top:20px; }
    th, td { padding:12px; border:1px solid #ddd; text-align:center; }
    th { background:#333; color:#fff; }
    form { margin:0; }
    select { padding:5px; }
    button { padding:5px 10px; background:#007bff; color:white; border:none; border-radius:5px; cursor:pointer; }
    button:hover { background:#0056b3; }
  </style>
</head>
<body>
  <h1>✏ Edit Kehadiran - <?= htmlspecialchars($employee['name']) ?></h1>
  <table>
    <tr>
      <th>Tanggal</th>
      <th>RFID UID</th>
      <th>Status</th>
      <th>Aksi</th>
    </tr>
    <?php foreach ($attendances as $att): ?>
    <tr>
      <td><?= $att['created_at'] ?></td>
      <td><?= htmlspecialchars($att['rfid_uid']) ?></td>
      <td>
        <form method="POST">
          <input type="hidden" name="attendance_id" value="<?= $att['id'] ?>">
          <select name="status">
            <option value="hadir" <?= $att['status']=='hadir'?'selected':'' ?>>Hadir</option>
            <option value="izin" <?= $att['status']=='izin'?'selected':'' ?>>Izin</option>
            <option value="sakit" <?= $att['status']=='sakit'?'selected':'' ?>>Sakit</option>
            <option value="alpha" <?= $att['status']=='alpha'?'selected':'' ?>>Alpha</option>
          </select>
          <button type="submit">Simpan</button>
        </form>
      </td>
      <td>#<?= $att['id'] ?></td>
    </tr>
    <?php endforeach; ?>
  </table>
  <p><a href="employees.php">⬅ Kembali ke Data Karyawan</a></p>
</body>
</html>
