<?php
// employee_add.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require_once __DIR__ . '/../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $department = trim($_POST['department']);
    $rfid_uid = trim($_POST['rfid_uid']);

    if ($name && $department && $rfid_uid) {
        try {
            $stmt = $pdo->prepare("INSERT INTO employees (name, department, rfid_uid) VALUES (?, ?, ?)");
            $stmt->execute([$name, $department, $rfid_uid]);

            header("Location: employees.php?success=1");
            exit;
        } catch (PDOException $e) {
            $error = "Gagal menyimpan karyawan: " . $e->getMessage();
        }
    } else {
        $error = "Semua field wajib diisi!";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Tambah Karyawan</title>
  <style>
    body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
    .container { max-width: 500px; margin: auto; background: white; padding: 20px; border-radius: 8px; }
    input, select, button { width: 100%; padding: 8px; margin: 6px 0; }
    button { background: #4CAF50; color: white; border: none; cursor: pointer; }
    button:hover { background: #45a049; }
    .error { color: red; }
  </style>
</head>
<body>
<div class="container">
  <h2>Tambah Karyawan</h2>
  <?php if (!empty($error)): ?>
    <p class="error"><?= htmlspecialchars($error) ?></p>
  <?php endif; ?>
  <form method="POST">
    <label>Nama:</label>
    <input type="text" name="name" required>

    <label>Departemen:</label>
    <input type="text" name="department" required>

    <label>RFID UID:</label>
    <input type="text" name="rfid_uid" required>

    <button type="submit">Simpan</button>
  </form>
  <p><a href="employees.php">← Kembali ke Daftar Karyawan</a></p>
</div>
</body>
</html>
