<?php
require_once __DIR__ . '/../config/config.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);
//$pdo = getDB();

// Hapus karyawan
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM employees WHERE id = ?");
    $stmt->execute([$id]);
    header("Location: employees.php");
    exit;
}

// Ambil data karyawan
$stmt = $pdo->query("SELECT * FROM employees ORDER BY id DESC");
$employees = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Data Karyawan</title>
  <style>
    body { font-family: Arial, sans-serif; background:#f4f4f4; padding:20px; }
    h1 { text-align:center; }
    table { width:100%; border-collapse: collapse; background:#fff; margin-top:20px; }
    th, td { padding:12px; border:1px solid #ddd; text-align:center; }
    th { background:#333; color:#fff; }
    a.button { padding:6px 12px; margin:2px; text-decoration:none; border-radius:5px; }
    .edit { background:#007bff; color:white; }
    .delete { background:#dc3545; color:white; }
    .add { background:#28a745; color:white; display:inline-block; margin-bottom:10px; }
  </style>
</head>
<body>
  <h1>📋 Data Karyawan</h1>

  <a href="employees_add.php" class="button add">+ Tambah Karyawan</a>

  <table>
    <tr>
      <th>ID</th>
      <th>Nama</th>
      <th>RFID UID</th>
      <th>Departemen</th>
      <th>Aksi</th>
    </tr>
    <?php foreach ($employees as $emp): ?>
    <tr>
      <td><?= $emp['id'] ?></td>
      <td><?= htmlspecialchars($emp['name']) ?></td>
      <td><?= htmlspecialchars($emp['rfid_uid']) ?></td>
      <td><?= htmlspecialchars($emp['department']) ?></td>
      <td>
        <a href="employees_edit.php?id=<?= $emp['id'] ?>" class="button edit">✏ Edit Kehadiran</a>
        <a href="employees.php?delete=<?= $emp['id'] ?>" class="button delete" onclick="return confirm('Yakin ingin hapus karyawan ini?')">🗑 Hapus</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </table>
</body>
</html>
