<?php
require_once __DIR__ . '/../config/config.php';
require_login();

$stmt = $pdo->query('SELECT a.*, e.name, e.email FROM attendances a LEFT JOIN employees e ON a.employee_id = e.id ORDER BY a.created_at DESC LIMIT 50');
$rows = $stmt->fetchAll();
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Dashboard - Absensi RFID</title>
  <link rel="stylesheet" href="/public/css/style.css">
</head>
<body>
  <div class="container">
    <h1>Dashboard Absensi</h1>
    <p><a href="employees.php">Kelola Karyawan</a> | <a href="add_employee.php">Tambah Karyawan</a> | <a href="logout.php">Logout</a></p>
    <table border="1" cellpadding="6">
      <thead><tr><th>Waktu</th><th>Nama</th><th>Email</th><th>RFID UID</th><th>Status</th></tr></thead>
      <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?=htmlspecialchars($r['created_at'])?></td>
          <td><?=htmlspecialchars($r['name'] ?? 'Unknown')?></td>
          <td><?=htmlspecialchars($r['email'] ?? '-')?></td>
          <td><?=htmlspecialchars($r['rfid_uid'])?></td>
          <td><?=htmlspecialchars($r['status'])?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
