<?php
require_once __DIR__ . '/../config/config.php';
require_login();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $rfid = trim($_POST['rfid_uid']);
    if ($name && $rfid) {
        $ins = $pdo->prepare('INSERT INTO employees (name, email, rfid_uid) VALUES (?, ?, ?)');
        try {
            $ins->execute([$name, $email ?: null, $rfid]);
            $msg = 'Karyawan ditambahkan';
        } catch (Exception $e) {
            $err = 'Gagal: ' . $e->getMessage();
        }
    } else {
        $err = 'Nama dan RFID UID wajib diisi';
    }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Tambah Karyawan</title>
  <link rel="stylesheet" href="/public/css/style.css">
</head>
<body>
  <div class="container">
    <h1>Tambah Karyawan</h1>
    <p><a href="employees.php">Kembali</a></p>
    <?php if (!empty($msg)) echo '<p class="success">'.htmlspecialchars($msg).'</p>'; ?>
    <?php if (!empty($err)) echo '<p class="error">'.htmlspecialchars($err).'</p>'; ?>
    <form method="post">
      <label>Nama<br><input name="name"></label><br>
      <label>Email<br><input name="email"></label><br>
      <label>RFID UID (contoh: 24A1B2C3)<br><input name="rfid_uid"></label><br>
      <button type="submit">Simpan</button>
    </form>
  </div>
</body>
</html>
