<?php
// Endpoint untuk menerima scan RFID dari device
// Dapat menerima: POST JSON { "uid": "AB:CD:EF:01", "status": "masuk" } atau form-data

require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

$input = file_get_contents('php://input');
$data = json_decode($input, true);

if (!$data) {
    // fallback ke form-encoded
    $data = $_POST;
}

$uid = isset($data['uid']) ? trim($data['uid']) : null;
$status = isset($data['status']) ? trim($data['status']) : 'hadir';
$api_token = isset($data['api_token']) ? trim($data['api_token']) : null;

// Optional: simple API token check (jika Anda set env API_TOKEN)
$expected_token = getenv('API_TOKEN') ?: null;
if ($expected_token && $expected_token !== $api_token) {
    http_response_code(403);
    echo json_encode(['error' => 'Invalid API token']);
    exit;
}

if (!$uid) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing uid']);
    exit;
}

try {
    $stmt = $pdo->prepare('SELECT id FROM employees WHERE rfid_uid = ? LIMIT 1');
    $stmt->execute([$uid]);
    $emp = $stmt->fetch();
    $employee_id = $emp ? $emp['id'] : null;

    $ins = $pdo->prepare('INSERT INTO attendances (employee_id, rfid_uid, status) VALUES (?, ?, ?)');
    $ins->execute([$employee_id, $uid, $status]);

    echo json_encode(['ok' => true, 'employee_id' => $employee_id]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>
