Contoh device (ESP8266/ESP32) mengirim UID ke server menggunakan HTTP POST JSON.

```cpp
#include <ESP8266WiFi.h>
#include <ESP8266HTTPClient.h>
#include <MFRC522.h>
#include <SPI.h>

const char* ssid = "YOUR_SSID";
const char* pass = "YOUR_PASS";
const char* serverUrl = "http://your-server.com/api/rfid.php"; // ganti

#define RST_PIN D1
#define SS_PIN D2
MFRC522 mfrc522(SS_PIN, RST_PIN);

void setup() {
  Serial.begin(115200);
  SPI.begin();
  mfrc522.PCD_Init();
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) { delay(500); Serial.print('.'); }
}

void loop() {
  if ( ! mfrc522.PICC_IsNewCardPresent()) return;
  if ( ! mfrc522.PICC_ReadCardSerial()) return;
  String uid = "";
  for (byte i = 0; i < mfrc522.uid.size; i++) {
    if (i > 0) uid += ":";
    uid += String(mfrc522.uid.uidByte[i], HEX);
  }

  // kirim ke server
  if (WiFi.status() == WL_CONNECTED) {
    HTTPClient http;
    http.begin(serverUrl);
    http.addHeader("Content-Type", "application/json");
    String payload = "{\"uid\":\"" + uid + "\",\"status\":\"hadir\"}";
    int code = http.POST(payload);
    Serial.println(code);
    http.end();
  }

  delay(1500);
}
```
